;***** THIS IS A MACHINE GENERATED FILE - DO NOT EDIT ********************
;***** Created: 2011-02-09 12:03 ******* Source: ATmega328P.xml **********
;*************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number            : AVR000
;* File Name         : "m328Pdef.inc"
;* Title             : Register/Bit Definitions for the ATmega328P
;* Date              : 2011-02-09
;* Version           : 2.35
;* Support E-mail    : avr@atmel.com
;* Target MCU        : ATmega328P
;* 
;* DESCRIPTION
;* When including this file in the assembly program file, all I/O register 
;* names and I/O register bit names appearing in the data book can be used.
;* In addition, the six registers forming the three data pointers X, Y and 
;* Z have been assigned names XL - ZH. Highest RAM address for Internal 
;* SRAM is also defined 
;* 
;* The Register names are represented by their hexadecimal address.
;* 
;* The Register Bit names are represented by their bit number (0-7).
;* 
;* Please observe the difference in using the bit names with instructions
;* such as "sbr"/"cbr" (set/clear bit in register) and "sbrs"/"sbrc"
;* (skip if bit in register set/cleared). The following example illustrates
;* this:
;* 
;* in    r16,PORTB             ;read PORTB latch
;* sbr   r16,(1<<PB6)+(1<<PB5) ;set PB6 and PB5 (use masks, not bit#)
;* out   PORTB,r16             ;output to PORTB
;* 
;* in    r16,TIFR              ;read the Timer Interrupt Flag Register
;* sbrc  r16,TOV0              ;test the overflow flag (use bit#)
;* rjmp  TOV0_is_set           ;jump if set
;* ...                         ;otherwise do something else
;*************************************************************************

#ifndef _M328PDEF_INC_
#define _M328PDEF_INC_


;#pragma partinc 0

; ***** SPECIFY DEVICE ***************************************************
;.device ATmega328P
#pragma AVRPART ADMIN PART_NAME ATmega328P
.set	SIGNATURE_000	, 0x1e
.set	SIGNATURE_001	, 0x95
.set	SIGNATURE_002	, 0x0f

#pragma AVRPART CORE CORE_VERSION V2E


; ***** I/O REGISTER DEFINITIONS *****************************************
; NOTE:
; Definitions marked "MEMORY MAPPED"are extended I/O ports
; and cannot be used with IN/OUT instructions
.set	UDR0	, 0xc6	; MEMORY MAPPED
.set	UBRR0L	, 0xc4	; MEMORY MAPPED
.set	UBRR0H	, 0xc5	; MEMORY MAPPED
.set	UCSR0C	, 0xc2	; MEMORY MAPPED
.set	UCSR0B	, 0xc1	; MEMORY MAPPED
.set	UCSR0A	, 0xc0	; MEMORY MAPPED
.set	TWAMR	, 0xbd	; MEMORY MAPPED
.set	TWCR	, 0xbc	; MEMORY MAPPED
.set	TWDR	, 0xbb	; MEMORY MAPPED
.set	TWAR	, 0xba	; MEMORY MAPPED
.set	TWSR	, 0xb9	; MEMORY MAPPED
.set	TWBR	, 0xb8	; MEMORY MAPPED
.set	ASSR	, 0xb6	; MEMORY MAPPED
.set	OCR2B	, 0xb4	; MEMORY MAPPED
.set	OCR2A	, 0xb3	; MEMORY MAPPED
.set	TCNT2	, 0xb2	; MEMORY MAPPED
.set	TCCR2B	, 0xb1	; MEMORY MAPPED
.set	TCCR2A	, 0xb0	; MEMORY MAPPED
.set	OCR1BL	, 0x8a	; MEMORY MAPPED
.set	OCR1BH	, 0x8b	; MEMORY MAPPED
.set	OCR1AL	, 0x88	; MEMORY MAPPED
.set	OCR1AH	, 0x89	; MEMORY MAPPED
.set	ICR1L	, 0x86	; MEMORY MAPPED
.set	ICR1H	, 0x87	; MEMORY MAPPED
.set	TCNT1L	, 0x84	; MEMORY MAPPED
.set	TCNT1H	, 0x85	; MEMORY MAPPED
.set	TCCR1C	, 0x82	; MEMORY MAPPED
.set	TCCR1B	, 0x81	; MEMORY MAPPED
.set	TCCR1A	, 0x80	; MEMORY MAPPED
.set	DIDR1	, 0x7f	; MEMORY MAPPED
.set	DIDR0	, 0x7e	; MEMORY MAPPED
.set	ADMUX	, 0x7c	; MEMORY MAPPED
.set	ADCSRB	, 0x7b	; MEMORY MAPPED
.set	ADCSRA	, 0x7a	; MEMORY MAPPED
.set	ADCH	, 0x79	; MEMORY MAPPED
.set	ADCL	, 0x78	; MEMORY MAPPED
.set	TIMSK2	, 0x70	; MEMORY MAPPED
.set	TIMSK1	, 0x6f	; MEMORY MAPPED
.set	TIMSK0	, 0x6e	; MEMORY MAPPED
.set	PCMSK1	, 0x6c	; MEMORY MAPPED
.set	PCMSK2	, 0x6d	; MEMORY MAPPED
.set	PCMSK0	, 0x6b	; MEMORY MAPPED
.set	EICRA	, 0x69	; MEMORY MAPPED
.set	PCICR	, 0x68	; MEMORY MAPPED
.set	OSCCAL	, 0x66	; MEMORY MAPPED
.set	PRR	, 0x64	; MEMORY MAPPED
.set	CLKPR	, 0x61	; MEMORY MAPPED
.set	WDTCSR	, 0x60	; MEMORY MAPPED
.set	SREG	, 0x3f
.set	SPL	, 0x3d
.set	SPH	, 0x3e
.set	SPMCSR	, 0x37
.set	MCUCR	, 0x35
.set	MCUSR	, 0x34
.set	SMCR	, 0x33
.set	ACSR	, 0x30
.set	SPDR	, 0x2e
.set	SPSR	, 0x2d
.set	SPCR	, 0x2c
.set	GPIOR2	, 0x2b
.set	GPIOR1	, 0x2a
.set	OCR0B	, 0x28
.set	OCR0A	, 0x27
.set	TCNT0	, 0x26
.set	TCCR0B	, 0x25
.set	TCCR0A	, 0x24
.set	GTCCR	, 0x23
.set	EEARH	, 0x22
.set	EEARL	, 0x21
.set	EEDR	, 0x20
.set	EECR	, 0x1f
.set	GPIOR0	, 0x1e
.set	EIMSK	, 0x1d
.set	EIFR	, 0x1c
.set	PCIFR	, 0x1b
.set	TIFR2	, 0x17
.set	TIFR1	, 0x16
.set	TIFR0	, 0x15
.set	PORTD	, 0x0b
.set	DDRD	, 0x0a
.set	PIND	, 0x09
.set	PORTC	, 0x08
.set	DDRC	, 0x07
.set	PINC	, 0x06
.set	PORTB	, 0x05
.set	DDRB	, 0x04
.set	PINB	, 0x03


; ***** BIT DEFINITIONS **************************************************

; ***** USART0 ***********************
; UDR0 - USART I/O Data Register
.set	UDR0_0	, 0	; USART I/O Data Register bit 0
.set	UDR0_1	, 1	; USART I/O Data Register bit 1
.set	UDR0_2	, 2	; USART I/O Data Register bit 2
.set	UDR0_3	, 3	; USART I/O Data Register bit 3
.set	UDR0_4	, 4	; USART I/O Data Register bit 4
.set	UDR0_5	, 5	; USART I/O Data Register bit 5
.set	UDR0_6	, 6	; USART I/O Data Register bit 6
.set	UDR0_7	, 7	; USART I/O Data Register bit 7

; UCSR0A - USART Control and Status Register A
.set	MPCM0	, 0	; Multi-processor Communication Mode
.set	U2X0	, 1	; Double the USART transmission speed
.set	UPE0	, 2	; Parity Error
.set	DOR0	, 3	; Data overRun
.set	FE0	, 4	; Framing Error
.set	UDRE0	, 5	; USART Data Register Empty
.set	TXC0	, 6	; USART Transmitt Complete
.set	RXC0	, 7	; USART Receive Complete

; UCSR0B - USART Control and Status Register B
.set	TXB80	, 0	; Transmit Data Bit 8
.set	RXB80	, 1	; Receive Data Bit 8
.set	UCSZ02	, 2	; Character Size
.set	TXEN0	, 3	; Transmitter Enable
.set	RXEN0	, 4	; Receiver Enable
.set	UDRIE0	, 5	; USART Data register Empty Interrupt Enable
.set	TXCIE0	, 6	; TX Complete Interrupt Enable
.set	RXCIE0	, 7	; RX Complete Interrupt Enable

; UCSR0C - USART Control and Status Register C
.set	UCPOL0	, 0	; Clock Polarity
.set	UCSZ00	, 1	; Character Size
.set	UCPHA0	, UCSZ00	; For compatibility
.set	UCSZ01	, 2	; Character Size
.set	UDORD0	, UCSZ01	; For compatibility
.set	USBS0	, 3	; Stop Bit Select
.set	UPM00	, 4	; Parity Mode Bit 0
.set	UPM01	, 5	; Parity Mode Bit 1
.set	UMSEL00	, 6	; USART Mode Select
.set	UMSEL0	, UMSEL00	; For compatibility
.set	UMSEL01	, 7	; USART Mode Select
.set	UMSEL1	, UMSEL01	; For compatibility

; UBRR0H - USART Baud Rate Register High Byte
.set	UBRR8	, 0	; USART Baud Rate Register bit 8
.set	UBRR9	, 1	; USART Baud Rate Register bit 9
.set	UBRR10	, 2	; USART Baud Rate Register bit 10
.set	UBRR11	, 3	; USART Baud Rate Register bit 11

; UBRR0L - USART Baud Rate Register Low Byte
.set	_UBRR0	, 0	; USART Baud Rate Register bit 0
.set	_UBRR1	, 1	; USART Baud Rate Register bit 1
.set	UBRR2	, 2	; USART Baud Rate Register bit 2
.set	UBRR3	, 3	; USART Baud Rate Register bit 3
.set	UBRR4	, 4	; USART Baud Rate Register bit 4
.set	UBRR5	, 5	; USART Baud Rate Register bit 5
.set	UBRR6	, 6	; USART Baud Rate Register bit 6
.set	UBRR7	, 7	; USART Baud Rate Register bit 7


; ***** TWI **************************
; TWAMR - TWI (Slave) Address Mask Register
.set	TWAM0	, 1	; 
.set	TWAMR0	, TWAM0	; For compatibility
.set	TWAM1	, 2	; 
.set	TWAMR1	, TWAM1	; For compatibility
.set	TWAM2	, 3	; 
.set	TWAMR2	, TWAM2	; For compatibility
.set	TWAM3	, 4	; 
.set	TWAMR3	, TWAM3	; For compatibility
.set	TWAM4	, 5	; 
.set	TWAMR4	, TWAM4	; For compatibility
.set	TWAM5	, 6	; 
.set	TWAMR5	, TWAM5	; For compatibility
.set	TWAM6	, 7	; 
.set	TWAMR6	, TWAM6	; For compatibility

; TWBR - TWI Bit Rate register
.set	TWBR0	, 0	; 
.set	TWBR1	, 1	; 
.set	TWBR2	, 2	; 
.set	TWBR3	, 3	; 
.set	TWBR4	, 4	; 
.set	TWBR5	, 5	; 
.set	TWBR6	, 6	; 
.set	TWBR7	, 7	; 

; TWCR - TWI Control Register
.set	TWIE	, 0	; TWI Interrupt Enable
.set	TWEN	, 2	; TWI Enable Bit
.set	TWWC	, 3	; TWI Write Collition Flag
.set	TWSTO	, 4	; TWI Stop Condition Bit
.set	TWSTA	, 5	; TWI Start Condition Bit
.set	TWEA	, 6	; TWI Enable Acknowledge Bit
.set	TWINT	, 7	; TWI Interrupt Flag

; TWSR - TWI Status Register
.set	TWPS0	, 0	; TWI Prescaler
.set	TWPS1	, 1	; TWI Prescaler
.set	TWS3	, 3	; TWI Status
.set	TWS4	, 4	; TWI Status
.set	TWS5	, 5	; TWI Status
.set	TWS6	, 6	; TWI Status
.set	TWS7	, 7	; TWI Status

; TWDR - TWI Data register
.set	TWD0	, 0	; TWI Data Register Bit 0
.set	TWD1	, 1	; TWI Data Register Bit 1
.set	TWD2	, 2	; TWI Data Register Bit 2
.set	TWD3	, 3	; TWI Data Register Bit 3
.set	TWD4	, 4	; TWI Data Register Bit 4
.set	TWD5	, 5	; TWI Data Register Bit 5
.set	TWD6	, 6	; TWI Data Register Bit 6
.set	TWD7	, 7	; TWI Data Register Bit 7

; TWAR - TWI (Slave) Address register
.set	TWGCE	, 0	; TWI General Call Recognition Enable Bit
.set	TWA0	, 1	; TWI (Slave) Address register Bit 0
.set	TWA1	, 2	; TWI (Slave) Address register Bit 1
.set	TWA2	, 3	; TWI (Slave) Address register Bit 2
.set	TWA3	, 4	; TWI (Slave) Address register Bit 3
.set	TWA4	, 5	; TWI (Slave) Address register Bit 4
.set	TWA5	, 6	; TWI (Slave) Address register Bit 5
.set	TWA6	, 7	; TWI (Slave) Address register Bit 6


; ***** TIMER_COUNTER_1 **************
; TIMSK1 - Timer/Counter Interrupt Mask Register
.set	TOIE1	, 0	; Timer/Counter1 Overflow Interrupt Enable
.set	OCIE1A	, 1	; Timer/Counter1 Output CompareA Match Interrupt Enable
.set	OCIE1B	, 2	; Timer/Counter1 Output CompareB Match Interrupt Enable
.set	ICIE1	, 5	; Timer/Counter1 Input Capture Interrupt Enable

; TIFR1 - Timer/Counter Interrupt Flag register
.set	TOV1	, 0	; Timer/Counter1 Overflow Flag
.set	OCF1A	, 1	; Output Compare Flag 1A
.set	OCF1B	, 2	; Output Compare Flag 1B
.set	ICF1	, 5	; Input Capture Flag 1

; TCCR1A - Timer/Counter1 Control Register A
.set	WGM10	, 0	; Waveform Generation Mode
.set	WGM11	, 1	; Waveform Generation Mode
.set	COM1B0	, 4	; Compare Output Mode 1B, bit 0
.set	COM1B1	, 5	; Compare Output Mode 1B, bit 1
.set	COM1A0	, 6	; Comparet Ouput Mode 1A, bit 0
.set	COM1A1	, 7	; Compare Output Mode 1A, bit 1

; TCCR1B - Timer/Counter1 Control Register B
.set	CS10	, 0	; Prescaler source of Timer/Counter 1
.set	CS11	, 1	; Prescaler source of Timer/Counter 1
.set	CS12	, 2	; Prescaler source of Timer/Counter 1
.set	WGM12	, 3	; Waveform Generation Mode
.set	WGM13	, 4	; Waveform Generation Mode
.set	ICES1	, 6	; Input Capture 1 Edge Select
.set	ICNC1	, 7	; Input Capture 1 Noise Canceler

; TCCR1C - Timer/Counter1 Control Register C
.set	FOC1B	, 6	; 
.set	FOC1A	, 7	; 

; GTCCR - General Timer/Counter Control Register
.set	PSRSYNC	, 0	; Prescaler Reset Timer/Counter1 and Timer/Counter0
.set	TSM	, 7	; Timer/Counter Synchronization Mode


; ***** TIMER_COUNTER_2 **************
; TIMSK2 - Timer/Counter Interrupt Mask register
.set	TOIE2	, 0	; Timer/Counter2 Overflow Interrupt Enable
.set	TOIE2A	, TOIE2	; For compatibility
.set	OCIE2A	, 1	; Timer/Counter2 Output Compare Match A Interrupt Enable
.set	OCIE2B	, 2	; Timer/Counter2 Output Compare Match B Interrupt Enable

; TIFR2 - Timer/Counter Interrupt Flag Register
.set	TOV2	, 0	; Timer/Counter2 Overflow Flag
.set	OCF2A	, 1	; Output Compare Flag 2A
.set	OCF2B	, 2	; Output Compare Flag 2B

; TCCR2A - Timer/Counter2 Control Register A
.set	WGM20	, 0	; Waveform Genration Mode
.set	WGM21	, 1	; Waveform Genration Mode
.set	COM2B0	, 4	; Compare Output Mode bit 0
.set	COM2B1	, 5	; Compare Output Mode bit 1
.set	COM2A0	, 6	; Compare Output Mode bit 1
.set	COM2A1	, 7	; Compare Output Mode bit 1

; TCCR2B - Timer/Counter2 Control Register B
.set	CS20	, 0	; Clock Select bit 0
.set	CS21	, 1	; Clock Select bit 1
.set	CS22	, 2	; Clock Select bit 2
.set	WGM22	, 3	; Waveform Generation Mode
.set	FOC2B	, 6	; Force Output Compare B
.set	FOC2A	, 7	; Force Output Compare A

; TCNT2 - Timer/Counter2
.set	TCNT2_0	, 0	; Timer/Counter 2 bit 0
.set	TCNT2_1	, 1	; Timer/Counter 2 bit 1
.set	TCNT2_2	, 2	; Timer/Counter 2 bit 2
.set	TCNT2_3	, 3	; Timer/Counter 2 bit 3
.set	TCNT2_4	, 4	; Timer/Counter 2 bit 4
.set	TCNT2_5	, 5	; Timer/Counter 2 bit 5
.set	TCNT2_6	, 6	; Timer/Counter 2 bit 6
.set	TCNT2_7	, 7	; Timer/Counter 2 bit 7

; OCR2A - Timer/Counter2 Output Compare Register A
.set	OCR2A_0	, 0	; Timer/Counter2 Output Compare Register Bit 0
.set	OCR2A_1	, 1	; Timer/Counter2 Output Compare Register Bit 1
.set	OCR2A_2	, 2	; Timer/Counter2 Output Compare Register Bit 2
.set	OCR2A_3	, 3	; Timer/Counter2 Output Compare Register Bit 3
.set	OCR2A_4	, 4	; Timer/Counter2 Output Compare Register Bit 4
.set	OCR2A_5	, 5	; Timer/Counter2 Output Compare Register Bit 5
.set	OCR2A_6	, 6	; Timer/Counter2 Output Compare Register Bit 6
.set	OCR2A_7	, 7	; Timer/Counter2 Output Compare Register Bit 7

; OCR2B - Timer/Counter2 Output Compare Register B
.set	OCR2B_0	, 0	; Timer/Counter2 Output Compare Register Bit 0
.set	OCR2B_1	, 1	; Timer/Counter2 Output Compare Register Bit 1
.set	OCR2B_2	, 2	; Timer/Counter2 Output Compare Register Bit 2
.set	OCR2B_3	, 3	; Timer/Counter2 Output Compare Register Bit 3
.set	OCR2B_4	, 4	; Timer/Counter2 Output Compare Register Bit 4
.set	OCR2B_5	, 5	; Timer/Counter2 Output Compare Register Bit 5
.set	OCR2B_6	, 6	; Timer/Counter2 Output Compare Register Bit 6
.set	OCR2B_7	, 7	; Timer/Counter2 Output Compare Register Bit 7

; ASSR - Asynchronous Status Register
.set	TCR2BUB	, 0	; Timer/Counter Control Register2 Update Busy
.set	TCR2AUB	, 1	; Timer/Counter Control Register2 Update Busy
.set	OCR2BUB	, 2	; Output Compare Register 2 Update Busy
.set	OCR2AUB	, 3	; Output Compare Register2 Update Busy
.set	TCN2UB	, 4	; Timer/Counter2 Update Busy
.set	AS2	, 5	; Asynchronous Timer/Counter2
.set	EXCLK	, 6	; Enable External Clock Input

; GTCCR - General Timer Counter Control register
.set	PSRASY	, 1	; Prescaler Reset Timer/Counter2
.set	PSR2	, PSRASY	; For compatibility
;.set	TSM	, 7	; Timer/Counter Synchronization Mode


; ***** AD_CONVERTER *****************
; ADMUX - The ADC multiplexer Selection Register
.set	MUX0	, 0	; Analog Channel and Gain Selection Bits
.set	MUX1	, 1	; Analog Channel and Gain Selection Bits
.set	MUX2	, 2	; Analog Channel and Gain Selection Bits
.set	MUX3	, 3	; Analog Channel and Gain Selection Bits
.set	ADLAR	, 5	; Left Adjust Result
.set	REFS0	, 6	; Reference Selection Bit 0
.set	REFS1	, 7	; Reference Selection Bit 1

; ADCSRA - The ADC Control and Status register A
.set	ADPS0	, 0	; ADC  Prescaler Select Bits
.set	ADPS1	, 1	; ADC  Prescaler Select Bits
.set	ADPS2	, 2	; ADC  Prescaler Select Bits
.set	ADIE	, 3	; ADC Interrupt Enable
.set	ADIF	, 4	; ADC Interrupt Flag
.set	ADATE	, 5	; ADC  Auto Trigger Enable
.set	ADSC	, 6	; ADC Start Conversion
.set	ADEN	, 7	; ADC Enable

; ADCSRB - The ADC Control and Status register B
.set	ADTS0	, 0	; ADC Auto Trigger Source bit 0
.set	ADTS1	, 1	; ADC Auto Trigger Source bit 1
.set	ADTS2	, 2	; ADC Auto Trigger Source bit 2
.set	ACME	, 6	; 

; ADCH - ADC Data Register High Byte
.set	ADCH0	, 0	; ADC Data Register High Byte Bit 0
.set	ADCH1	, 1	; ADC Data Register High Byte Bit 1
.set	ADCH2	, 2	; ADC Data Register High Byte Bit 2
.set	ADCH3	, 3	; ADC Data Register High Byte Bit 3
.set	ADCH4	, 4	; ADC Data Register High Byte Bit 4
.set	ADCH5	, 5	; ADC Data Register High Byte Bit 5
.set	ADCH6	, 6	; ADC Data Register High Byte Bit 6
.set	ADCH7	, 7	; ADC Data Register High Byte Bit 7

; ADCL - ADC Data Register Low Byte
.set	ADCL0	, 0	; ADC Data Register Low Byte Bit 0
.set	ADCL1	, 1	; ADC Data Register Low Byte Bit 1
.set	ADCL2	, 2	; ADC Data Register Low Byte Bit 2
.set	ADCL3	, 3	; ADC Data Register Low Byte Bit 3
.set	ADCL4	, 4	; ADC Data Register Low Byte Bit 4
.set	ADCL5	, 5	; ADC Data Register Low Byte Bit 5
.set	ADCL6	, 6	; ADC Data Register Low Byte Bit 6
.set	ADCL7	, 7	; ADC Data Register Low Byte Bit 7

; DIDR0 - Digital Input Disable Register
.set	ADC0D	, 0	; 
.set	ADC1D	, 1	; 
.set	ADC2D	, 2	; 
.set	ADC3D	, 3	; 
.set	ADC4D	, 4	; 
.set	ADC5D	, 5	; 


; ***** ANALOG_COMPARATOR ************
; ACSR - Analog Comparator Control And Status Register
.set	ACIS0	, 0	; Analog Comparator Interrupt Mode Select bit 0
.set	ACIS1	, 1	; Analog Comparator Interrupt Mode Select bit 1
.set	ACIC	, 2	; Analog Comparator Input Capture Enable
.set	ACIE	, 3	; Analog Comparator Interrupt Enable
.set	ACI	, 4	; Analog Comparator Interrupt Flag
.set	ACO	, 5	; Analog Compare Output
.set	ACBG	, 6	; Analog Comparator Bandgap Select
.set	ACD	, 7	; Analog Comparator Disable

; DIDR1 - Digital Input Disable Register 1
.set	AIN0D	, 0	; AIN0 Digital Input Disable
.set	AIN1D	, 1	; AIN1 Digital Input Disable


; ***** PORTB ************************
; PORTB - Port B Data Register
.set	PORTB0	, 0	; Port B Data Register bit 0
.set	PB0	, 0	; For compatibility
.set	PORTB1	, 1	; Port B Data Register bit 1
.set	PB1	, 1	; For compatibility
.set	PORTB2	, 2	; Port B Data Register bit 2
.set	PB2	, 2	; For compatibility
.set	PORTB3	, 3	; Port B Data Register bit 3
.set	PB3	, 3	; For compatibility
.set	PORTB4	, 4	; Port B Data Register bit 4
.set	PB4	, 4	; For compatibility
.set	PORTB5	, 5	; Port B Data Register bit 5
.set	PB5	, 5	; For compatibility
.set	PORTB6	, 6	; Port B Data Register bit 6
.set	PB6	, 6	; For compatibility
.set	PORTB7	, 7	; Port B Data Register bit 7
.set	PB7	, 7	; For compatibility

; DDRB - Port B Data Direction Register
.set	DDB0	, 0	; Port B Data Direction Register bit 0
.set	DDB1	, 1	; Port B Data Direction Register bit 1
.set	DDB2	, 2	; Port B Data Direction Register bit 2
.set	DDB3	, 3	; Port B Data Direction Register bit 3
.set	DDB4	, 4	; Port B Data Direction Register bit 4
.set	DDB5	, 5	; Port B Data Direction Register bit 5
.set	DDB6	, 6	; Port B Data Direction Register bit 6
.set	DDB7	, 7	; Port B Data Direction Register bit 7

; PINB - Port B Input Pins
.set	PINB0	, 0	; Port B Input Pins bit 0
.set	PINB1	, 1	; Port B Input Pins bit 1
.set	PINB2	, 2	; Port B Input Pins bit 2
.set	PINB3	, 3	; Port B Input Pins bit 3
.set	PINB4	, 4	; Port B Input Pins bit 4
.set	PINB5	, 5	; Port B Input Pins bit 5
.set	PINB6	, 6	; Port B Input Pins bit 6
.set	PINB7	, 7	; Port B Input Pins bit 7


; ***** PORTC ************************
; PORTC - Port C Data Register
.set	PORTC0	, 0	; Port C Data Register bit 0
.set	PC0	, 0	; For compatibility
.set	PORTC1	, 1	; Port C Data Register bit 1
.set	PC1	, 1	; For compatibility
.set	PORTC2	, 2	; Port C Data Register bit 2
.set	PC2	, 2	; For compatibility
.set	PORTC3	, 3	; Port C Data Register bit 3
.set	PC3	, 3	; For compatibility
.set	PORTC4	, 4	; Port C Data Register bit 4
.set	PC4	, 4	; For compatibility
.set	PORTC5	, 5	; Port C Data Register bit 5
.set	PC5	, 5	; For compatibility
.set	PORTC6	, 6	; Port C Data Register bit 6
.set	PC6	, 6	; For compatibility

; DDRC - Port C Data Direction Register
.set	DDC0	, 0	; Port C Data Direction Register bit 0
.set	DDC1	, 1	; Port C Data Direction Register bit 1
.set	DDC2	, 2	; Port C Data Direction Register bit 2
.set	DDC3	, 3	; Port C Data Direction Register bit 3
.set	DDC4	, 4	; Port C Data Direction Register bit 4
.set	DDC5	, 5	; Port C Data Direction Register bit 5
.set	DDC6	, 6	; Port C Data Direction Register bit 6

; PINC - Port C Input Pins
.set	PINC0	, 0	; Port C Input Pins bit 0
.set	PINC1	, 1	; Port C Input Pins bit 1
.set	PINC2	, 2	; Port C Input Pins bit 2
.set	PINC3	, 3	; Port C Input Pins bit 3
.set	PINC4	, 4	; Port C Input Pins bit 4
.set	PINC5	, 5	; Port C Input Pins bit 5
.set	PINC6	, 6	; Port C Input Pins bit 6


; ***** PORTD ************************
; PORTD - Port D Data Register
.set	PORTD0	, 0	; Port D Data Register bit 0
.set	PD0	, 0	; For compatibility
.set	PORTD1	, 1	; Port D Data Register bit 1
.set	PD1	, 1	; For compatibility
.set	PORTD2	, 2	; Port D Data Register bit 2
.set	PD2	, 2	; For compatibility
.set	PORTD3	, 3	; Port D Data Register bit 3
.set	PD3	, 3	; For compatibility
.set	PORTD4	, 4	; Port D Data Register bit 4
.set	PD4	, 4	; For compatibility
.set	PORTD5	, 5	; Port D Data Register bit 5
.set	PD5	, 5	; For compatibility
.set	PORTD6	, 6	; Port D Data Register bit 6
.set	PD6	, 6	; For compatibility
.set	PORTD7	, 7	; Port D Data Register bit 7
.set	PD7	, 7	; For compatibility

; DDRD - Port D Data Direction Register
.set	DDD0	, 0	; Port D Data Direction Register bit 0
.set	DDD1	, 1	; Port D Data Direction Register bit 1
.set	DDD2	, 2	; Port D Data Direction Register bit 2
.set	DDD3	, 3	; Port D Data Direction Register bit 3
.set	DDD4	, 4	; Port D Data Direction Register bit 4
.set	DDD5	, 5	; Port D Data Direction Register bit 5
.set	DDD6	, 6	; Port D Data Direction Register bit 6
.set	DDD7	, 7	; Port D Data Direction Register bit 7

; PIND - Port D Input Pins
.set	PIND0	, 0	; Port D Input Pins bit 0
.set	PIND1	, 1	; Port D Input Pins bit 1
.set	PIND2	, 2	; Port D Input Pins bit 2
.set	PIND3	, 3	; Port D Input Pins bit 3
.set	PIND4	, 4	; Port D Input Pins bit 4
.set	PIND5	, 5	; Port D Input Pins bit 5
.set	PIND6	, 6	; Port D Input Pins bit 6
.set	PIND7	, 7	; Port D Input Pins bit 7


; ***** TIMER_COUNTER_0 **************
; TIMSK0 - Timer/Counter0 Interrupt Mask Register
.set	TOIE0	, 0	; Timer/Counter0 Overflow Interrupt Enable
.set	OCIE0A	, 1	; Timer/Counter0 Output Compare Match A Interrupt Enable
.set	OCIE0B	, 2	; Timer/Counter0 Output Compare Match B Interrupt Enable

; TIFR0 - Timer/Counter0 Interrupt Flag register
.set	TOV0	, 0	; Timer/Counter0 Overflow Flag
.set	OCF0A	, 1	; Timer/Counter0 Output Compare Flag 0A
.set	OCF0B	, 2	; Timer/Counter0 Output Compare Flag 0B

; TCCR0A - Timer/Counter  Control Register A
.set	WGM00	, 0	; Waveform Generation Mode
.set	WGM01	, 1	; Waveform Generation Mode
.set	COM0B0	, 4	; Compare Output Mode, Fast PWm
.set	COM0B1	, 5	; Compare Output Mode, Fast PWm
.set	COM0A0	, 6	; Compare Output Mode, Phase Correct PWM Mode
.set	COM0A1	, 7	; Compare Output Mode, Phase Correct PWM Mode

; TCCR0B - Timer/Counter Control Register B
.set	CS00	, 0	; Clock Select
.set	CS01	, 1	; Clock Select
.set	CS02	, 2	; Clock Select
.set	WGM02	, 3	; 
.set	FOC0B	, 6	; Force Output Compare B
.set	FOC0A	, 7	; Force Output Compare A

; TCNT0 - Timer/Counter0
.set	TCNT0_0	, 0	; 
.set	TCNT0_1	, 1	; 
.set	TCNT0_2	, 2	; 
.set	TCNT0_3	, 3	; 
.set	TCNT0_4	, 4	; 
.set	TCNT0_5	, 5	; 
.set	TCNT0_6	, 6	; 
.set	TCNT0_7	, 7	; 

; OCR0A - Timer/Counter0 Output Compare Register
.set	OCR0A_0	, 0	; 
.set	OCR0A_1	, 1	; 
.set	OCR0A_2	, 2	; 
.set	OCR0A_3	, 3	; 
.set	OCR0A_4	, 4	; 
.set	OCR0A_5	, 5	; 
.set	OCR0A_6	, 6	; 
.set	OCR0A_7	, 7	; 

; OCR0B - Timer/Counter0 Output Compare Register
.set	OCR0B_0	, 0	; 
.set	OCR0B_1	, 1	; 
.set	OCR0B_2	, 2	; 
.set	OCR0B_3	, 3	; 
.set	OCR0B_4	, 4	; 
.set	OCR0B_5	, 5	; 
.set	OCR0B_6	, 6	; 
.set	OCR0B_7	, 7	; 

; GTCCR - General Timer/Counter Control Register
;.set	PSRSYNC	, 0	; Prescaler Reset Timer/Counter1 and Timer/Counter0
.set	PSR10	, PSRSYNC	; For compatibility
;.set	TSM	, 7	; Timer/Counter Synchronization Mode


; ***** EXTERNAL_INTERRUPT ***********
; EICRA - External Interrupt Control Register
.set	ISC00	, 0	; External Interrupt Sense Control 0 Bit 0
.set	ISC01	, 1	; External Interrupt Sense Control 0 Bit 1
.set	ISC10	, 2	; External Interrupt Sense Control 1 Bit 0
.set	ISC11	, 3	; External Interrupt Sense Control 1 Bit 1

; EIMSK - External Interrupt Mask Register
.set	INT0	, 0	; External Interrupt Request 0 Enable
.set	INT1	, 1	; External Interrupt Request 1 Enable

; EIFR - External Interrupt Flag Register
.set	INTF0	, 0	; External Interrupt Flag 0
.set	INTF1	, 1	; External Interrupt Flag 1

; PCICR - Pin Change Interrupt Control Register
.set	PCIE0	, 0	; Pin Change Interrupt Enable 0
.set	PCIE1	, 1	; Pin Change Interrupt Enable 1
.set	PCIE2	, 2	; Pin Change Interrupt Enable 2

; PCMSK2 - Pin Change Mask Register 2
.set	PCINT16	, 0	; Pin Change Enable Mask 16
.set	PCINT17	, 1	; Pin Change Enable Mask 17
.set	PCINT18	, 2	; Pin Change Enable Mask 18
.set	PCINT19	, 3	; Pin Change Enable Mask 19
.set	PCINT20	, 4	; Pin Change Enable Mask 20
.set	PCINT21	, 5	; Pin Change Enable Mask 21
.set	PCINT22	, 6	; Pin Change Enable Mask 22
.set	PCINT23	, 7	; Pin Change Enable Mask 23

; PCMSK1 - Pin Change Mask Register 1
.set	PCINT8	, 0	; Pin Change Enable Mask 8
.set	PCINT9	, 1	; Pin Change Enable Mask 9
.set	PCINT10	, 2	; Pin Change Enable Mask 10
.set	PCINT11	, 3	; Pin Change Enable Mask 11
.set	PCINT12	, 4	; Pin Change Enable Mask 12
.set	PCINT13	, 5	; Pin Change Enable Mask 13
.set	PCINT14	, 6	; Pin Change Enable Mask 14

; PCMSK0 - Pin Change Mask Register 0
.set	PCINT0	, 0	; Pin Change Enable Mask 0
.set	PCINT1	, 1	; Pin Change Enable Mask 1
.set	PCINT2	, 2	; Pin Change Enable Mask 2
.set	PCINT3	, 3	; Pin Change Enable Mask 3
.set	PCINT4	, 4	; Pin Change Enable Mask 4
.set	PCINT5	, 5	; Pin Change Enable Mask 5
.set	PCINT6	, 6	; Pin Change Enable Mask 6
.set	PCINT7	, 7	; Pin Change Enable Mask 7

; PCIFR - Pin Change Interrupt Flag Register
.set	PCIF0	, 0	; Pin Change Interrupt Flag 0
.set	PCIF1	, 1	; Pin Change Interrupt Flag 1
.set	PCIF2	, 2	; Pin Change Interrupt Flag 2


; ***** SPI **************************
; SPDR - SPI Data Register
.set	SPDR0	, 0	; SPI Data Register bit 0
.set	SPDR1	, 1	; SPI Data Register bit 1
.set	SPDR2	, 2	; SPI Data Register bit 2
.set	SPDR3	, 3	; SPI Data Register bit 3
.set	SPDR4	, 4	; SPI Data Register bit 4
.set	SPDR5	, 5	; SPI Data Register bit 5
.set	SPDR6	, 6	; SPI Data Register bit 6
.set	SPDR7	, 7	; SPI Data Register bit 7

; SPSR - SPI Status Register
.set	SPI2X	, 0	; Double SPI Speed Bit
.set	WCOL	, 6	; Write Collision Flag
.set	SPIF	, 7	; SPI Interrupt Flag

; SPCR - SPI Control Register
.set	SPR0	, 0	; SPI Clock Rate Select 0
.set	SPR1	, 1	; SPI Clock Rate Select 1
.set	CPHA	, 2	; Clock Phase
.set	CPOL	, 3	; Clock polarity
.set	MSTR	, 4	; Master/Slave Select
.set	DORD	, 5	; Data Order
.set	SPE	, 6	; SPI Enable
.set	SPIE	, 7	; SPI Interrupt Enable


; ***** WATCHDOG *********************
; WDTCSR - Watchdog Timer Control Register
.set	WDP0	, 0	; Watch Dog Timer Prescaler bit 0
.set	WDP1	, 1	; Watch Dog Timer Prescaler bit 1
.set	WDP2	, 2	; Watch Dog Timer Prescaler bit 2
.set	WDE	, 3	; Watch Dog Enable
.set	WDCE	, 4	; Watchdog Change Enable
.set	WDP3	, 5	; Watchdog Timer Prescaler Bit 3
.set	WDIE	, 6	; Watchdog Timeout Interrupt Enable
.set	WDIF	, 7	; Watchdog Timeout Interrupt Flag


; ***** CPU **************************
; SREG - Status Register
.set	SREG_C	, 0	; Carry Flag
.set	SREG_Z	, 1	; Zero Flag
.set	SREG_N	, 2	; Negative Flag
.set	SREG_V	, 3	; Two's Complement Overflow Flag
.set	SREG_S	, 4	; Sign Bit
.set	SREG_H	, 5	; Half Carry Flag
.set	SREG_T	, 6	; Bit Copy Storage
.set	SREG_I	, 7	; Global Interrupt Enable

; OSCCAL - Oscillator Calibration Value
.set	CAL0	, 0	; Oscillator Calibration Value Bit0
.set	CAL1	, 1	; Oscillator Calibration Value Bit1
.set	CAL2	, 2	; Oscillator Calibration Value Bit2
.set	CAL3	, 3	; Oscillator Calibration Value Bit3
.set	CAL4	, 4	; Oscillator Calibration Value Bit4
.set	CAL5	, 5	; Oscillator Calibration Value Bit5
.set	CAL6	, 6	; Oscillator Calibration Value Bit6
.set	CAL7	, 7	; Oscillator Calibration Value Bit7

; CLKPR - Clock Prescale Register
.set	CLKPS0	, 0	; Clock Prescaler Select Bit 0
.set	CLKPS1	, 1	; Clock Prescaler Select Bit 1
.set	CLKPS2	, 2	; Clock Prescaler Select Bit 2
.set	CLKPS3	, 3	; Clock Prescaler Select Bit 3
.set	CLKPCE	, 7	; Clock Prescaler Change Enable

; SPMCSR - Store Program Memory Control and Status Register
.set	SELFPRGEN	, 0	; Self Programming Enable
.set	PGERS	, 1	; Page Erase
.set	PGWRT	, 2	; Page Write
.set	BLBSET	, 3	; Boot Lock Bit Set
.set	RWWSRE	, 4	; Read-While-Write section read enable
.set	RWWSB	, 6	; Read-While-Write Section Busy
.set	SPMIE	, 7	; SPM Interrupt Enable

; MCUCR - MCU Control Register
.set	IVCE	, 0	; 
.set	IVSEL	, 1	; 
.set	PUD	, 4	; 
.set	BODSE	, 5	; BOD Sleep Enable
.set	BODS	, 6	; BOD Sleep

; MCUSR - MCU Status Register
.set	PORF	, 0	; Power-on reset flag
.set	EXTRF	, 1	; External Reset Flag
.set	EXTREF	, EXTRF	; For compatibility
.set	BORF	, 2	; Brown-out Reset Flag
.set	WDRF	, 3	; Watchdog Reset Flag

; SMCR - Sleep Mode Control Register
.set	SE	, 0	; Sleep Enable
.set	SM0	, 1	; Sleep Mode Select Bit 0
.set	SM1	, 2	; Sleep Mode Select Bit 1
.set	SM2	, 3	; Sleep Mode Select Bit 2

; GPIOR2 - General Purpose I/O Register 2
.set	GPIOR20	, 0	; 
.set	GPIOR21	, 1	; 
.set	GPIOR22	, 2	; 
.set	GPIOR23	, 3	; 
.set	GPIOR24	, 4	; 
.set	GPIOR25	, 5	; 
.set	GPIOR26	, 6	; 
.set	GPIOR27	, 7	; 

; GPIOR1 - General Purpose I/O Register 1
.set	GPIOR10	, 0	; 
.set	GPIOR11	, 1	; 
.set	GPIOR12	, 2	; 
.set	GPIOR13	, 3	; 
.set	GPIOR14	, 4	; 
.set	GPIOR15	, 5	; 
.set	GPIOR16	, 6	; 
.set	GPIOR17	, 7	; 

; GPIOR0 - General Purpose I/O Register 0
.set	GPIOR00	, 0	; 
.set	GPIOR01	, 1	; 
.set	GPIOR02	, 2	; 
.set	GPIOR03	, 3	; 
.set	GPIOR04	, 4	; 
.set	GPIOR05	, 5	; 
.set	GPIOR06	, 6	; 
.set	GPIOR07	, 7	; 

; PRR - Power Reduction Register
.set	PRADC	, 0	; Power Reduction ADC
.set	PRUSART0	, 1	; Power Reduction USART
.set	PRSPI	, 2	; Power Reduction Serial Peripheral Interface
.set	PRTIM1	, 3	; Power Reduction Timer/Counter1
.set	PRTIM0	, 5	; Power Reduction Timer/Counter0
.set	PRTIM2	, 6	; Power Reduction Timer/Counter2
.set	PRTWI	, 7	; Power Reduction TWI


; ***** EEPROM ***********************
; EEARL - EEPROM Address Register Low Byte
.set	EEAR0	, 0	; EEPROM Read/Write Access Bit 0
.set	EEAR1	, 1	; EEPROM Read/Write Access Bit 1
.set	EEAR2	, 2	; EEPROM Read/Write Access Bit 2
.set	EEAR3	, 3	; EEPROM Read/Write Access Bit 3
.set	EEAR4	, 4	; EEPROM Read/Write Access Bit 4
.set	EEAR5	, 5	; EEPROM Read/Write Access Bit 5
.set	EEAR6	, 6	; EEPROM Read/Write Access Bit 6
.set	EEAR7	, 7	; EEPROM Read/Write Access Bit 7

; EEARH - EEPROM Address Register High Byte
.set	EEAR8	, 0	; EEPROM Read/Write Access Bit 8
.set	EEAR9	, 1	; EEPROM Read/Write Access Bit 9

; EEDR - EEPROM Data Register
.set	EEDR0	, 0	; EEPROM Data Register bit 0
.set	EEDR1	, 1	; EEPROM Data Register bit 1
.set	EEDR2	, 2	; EEPROM Data Register bit 2
.set	EEDR3	, 3	; EEPROM Data Register bit 3
.set	EEDR4	, 4	; EEPROM Data Register bit 4
.set	EEDR5	, 5	; EEPROM Data Register bit 5
.set	EEDR6	, 6	; EEPROM Data Register bit 6
.set	EEDR7	, 7	; EEPROM Data Register bit 7

; EECR - EEPROM Control Register
.set	EERE	, 0	; EEPROM Read Enable
.set	EEPE	, 1	; EEPROM Write Enable
.set	EEMPE	, 2	; EEPROM Master Write Enable
.set	EERIE	, 3	; EEPROM Ready Interrupt Enable
.set	EEPM0	, 4	; EEPROM Programming Mode Bit 0
.set	EEPM1	, 5	; EEPROM Programming Mode Bit 1



; ***** LOCKSBITS ********************************************************
.set	LB1	, 0	; Lock bit
.set	LB2	, 1	; Lock bit
.set	BLB01	, 2	; Boot Lock bit
.set	BLB02	, 3	; Boot Lock bit
.set	BLB11	, 4	; Boot lock bit
.set	BLB12	, 5	; Boot lock bit


; ***** FUSES ************************************************************
; LOW fuse bits
.set	CKSEL0	, 0	; Select Clock Source
.set	CKSEL1	, 1	; Select Clock Source
.set	CKSEL2	, 2	; Select Clock Source
.set	CKSEL3	, 3	; Select Clock Source
.set	SUT0	, 4	; Select start-up time
.set	SUT1	, 5	; Select start-up time
.set	CKOUT	, 6	; Clock output
.set	CKDIV8	, 7	; Divide clock by 8

; HIGH fuse bits
.set	BOOTRST	, 0	; Select reset vector
.set	BOOTSZ0	, 1	; Select boot size
.set	BOOTSZ1	, 2	; Select boot size
.set	EESAVE	, 3	; EEPROM memory is preserved through chip erase
.set	WDTON	, 4	; Watchdog Timer Always On
.set	SPIEN	, 5	; Enable Serial programming and Data Downloading
.set	DWEN	, 6	; debugWIRE Enable
.set	RSTDISBL	, 7	; External reset disable

; EXTENDED fuse bits
.set	BODLEVEL0	, 0	; Brown-out Detector trigger level
.set	BODLEVEL1	, 1	; Brown-out Detector trigger level
.set	BODLEVEL2	, 2	; Brown-out Detector trigger level



; ***** CPU REGISTER DEFINITIONS *****************************************
#define XH R27
#define XL R26
#define YH R29
#define YL R28
#define ZH R31
#define ZL R30
;.set	XH	, r27
;.set	XL	, r26
;.set	YH	, r29
;.set	YL	, r28
;.set	ZH	, r31
;.set	ZL	, r30



; ***** DATA MEMORY DECLARATIONS *****************************************
.set	FLASHEND	, 0x3fff	; Note: Word address
.set	IOEND	, 0x00ff
.set	SRAM_START	, 0x0100
.set	SRAM_SIZE	, 2048
.set	RAMEND	, 0x08ff
.set	XRAMEND	, 0x0000
.set	E2END	, 0x03ff
.set	EEPROMEND	, 0x03ff
.set	EEADRBITS	, 10
#pragma AVRPART MEMORY PROG_FLASH 32768
#pragma AVRPART MEMORY EEPROM 1024
#pragma AVRPART MEMORY INT_SRAM SIZE 2048
#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100



; ***** BOOTLOADER DECLARATIONS ******************************************
.set	NRWW_START_ADDR	, 0x3800
.set	NRWW_STOP_ADDR	, 0x3fff
.set	RWW_START_ADDR	, 0x0
.set	RWW_STOP_ADDR	, 0x37ff
.set	PAGESIZE	, 64
.set	FIRSTBOOTSTART	, 0x3f00
.set	SECONDBOOTSTART	, 0x3e00
.set	THIRDBOOTSTART	, 0x3c00
.set	FOURTHBOOTSTART	, 0x3800
.set	SMALLBOOTSTART	, FIRSTBOOTSTART
.set	LARGEBOOTSTART	, FOURTHBOOTSTART



; ***** INTERRUPT VECTORS ************************************************
.set	INT0addr	, 0x0002	; External Interrupt Request 0
.set	INT1addr	, 0x0004	; External Interrupt Request 1
.set	PCI0addr	, 0x0006	; Pin Change Interrupt Request 0
.set	PCI1addr	, 0x0008	; Pin Change Interrupt Request 0
.set	PCI2addr	, 0x000a	; Pin Change Interrupt Request 1
.set	WDTaddr	, 0x000c	; Watchdog Time-out Interrupt
.set	OC2Aaddr	, 0x000e	; Timer/Counter2 Compare Match A
.set	OC2Baddr	, 0x0010	; Timer/Counter2 Compare Match A
.set	OVF2addr	, 0x0012	; Timer/Counter2 Overflow
.set	ICP1addr	, 0x0014	; Timer/Counter1 Capture Event
.set	OC1Aaddr	, 0x0016	; Timer/Counter1 Compare Match A
.set	OC1Baddr	, 0x0018	; Timer/Counter1 Compare Match B
.set	OVF1addr	, 0x001a	; Timer/Counter1 Overflow
.set	OC0Aaddr	, 0x001c	; TimerCounter0 Compare Match A
.set	OC0Baddr	, 0x001e	; TimerCounter0 Compare Match B
.set	OVF0addr	, 0x0020	; Timer/Couner0 Overflow
.set	SPIaddr	, 0x0022	; SPI Serial Transfer Complete
.set	URXCaddr	, 0x0024	; USART Rx Complete
.set	UDREaddr	, 0x0026	; USART, Data Register Empty
.set	UTXCaddr	, 0x0028	; USART Tx Complete
.set	ADCCaddr	, 0x002a	; ADC Conversion Complete
.set	ERDYaddr	, 0x002c	; EEPROM Ready
.set	ACIaddr	, 0x002e	; Analog Comparator
.set	TWIaddr	, 0x0030	; Two-wire Serial Interface
.set	SPMRaddr	, 0x0032	; Store Program Memory Read

.set	INT_VECTORS_SIZE	, 52	; size in words

#endif  /* _M328PDEF_INC_ */

; ***** END OF FILE ******************************************************
